  /*
   *  Object          : Code_prot.h
   *  State           :  %state%
   *  Creation date   :  Wed Nov 17 17:26:15 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief this file containes the declerations of the code protection algorythems, ECC and checksum.
   *         
   *
   *  \version Code_prot.h#1:csrc:3
   *  \author adams
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ****************/
#include "DX_VOS_basetypes.h"


/**
 * @brief This function calculate the ECC for byte strings from 1 byte to 8 bytes.
 *        only 1,4,8,16,32 bytes length strings are supported.
 *
 * The function gets stings and its length
 *
 * @param[in] data - pointer to the data string. 
 *
 * @param[in] length  the length of the string. 
 *
 * @param[Out] Ecc  The Ecc value for the sring (Ecce |Ecco<< log2(length))
 *
 * @return DxUint32_t - On success the value 0 is returned, 
 *                        only errors are parameters error than the return is -1.
 */
 DxUint32_t DX_SEP_GEN_ECC_calc_ROM(const DxUint32_t *data, DxUint32_t length);

 /**
 * @brief This function Gets 2 ECCs and data. It checks the ECCs and in case of one bit error fix the data.
 *        only 1,4,8,16,32 bytes length strings are supported.
 *
 *		In case of no error or one bit errror the function returns success (0)
 *		else it returns failure (-1)
 *
 * The function gets 2 ECCs values data string and its length
 *
 * @param[in] oldEcc - First ECC value to be checked. 
 *
 * @param[in] newEcc - second ECC value to be checked. 
 *
 * @param[in] data - pointer to the data string. 
 *
 * @param[in] datalen  the length of the string. 
 *
 * @return DxUint32_t - On success the value 0 is returned, 
 *                        only errors are parameters error than the return is -1.
 *
 *	The Ecc valu is made of (Ecce |Ecco<< log2(length))
 *	In case of Error the XOR of the new ECCo and old ECCo gives the error bit.
 *	The bit place is the 3 LSBs of the ECCos and the byte is the rest MSBs
 *
 *
 */

DxUint32_t DX_SEP_GEN_EccCheckAndFix_ROM(DxUint32_t oldEcc, DxUint32_t newEcc, DxUint32_t *data, DxUint32_t datalen);


/**
 * @brief This function calculate checksum for a string of words accroding to RFC 1071.
 * 
 *
 * The function gets stings and its length
 *
 * @param[in] data - pointer to the data string. 
 *
 * @param[in] length  the length of the string. 
 *
 * @return DxUint32_t - checksum in low 16 bits.
 *                        
 */
  DxUint32_t DX_SEP_GEN_CheckSumcalc_ROM(DxUint8_t *data, DxUint32_t length);
